#ifndef SERVOS_H_
#define SERVOS_H_

/* Includes ------------------------------------------------------------------*/
#include "stm32f10x_conf.h"

/* Exported types ------------------------------------------------------------*/
typedef enum
{
	SERVO_1,
	SERVO_2,
	SERVO_3

} servo_TypeDef;

/* Exported function prototypes ----------------------------------------------*/

// Servo_Init()
// ------------
// Initialize the servos module.
extern void Servos_Init();

#ifdef SERVOS_SET_INDIVIDUAL

// Servo_SetCalibration()
// ----------------------
// Set the calibration parameter for an individual servo.
extern void Servos_SetCalibration(servo_TypeDef servo, float calibration);

// Servo_SetAngle()
// ----------------
// Set the angle for an individual servo.
// Returns false if the requested angle is outside the range of the servo.
extern bool Servos_SetAngle(servo_TypeDef servo, float angle);

#endif

// Servo_SetAllCalibrations()
// ----------------------
// Set the calibration parameters for all servos simultaneously.
// Called from interrupt via Robot_OnADCCompete().
extern void Servos_SetAllCalibrations(float servo1Calibration, float servo2Calibration, float servo3Calibration);

// Servo_SetCalibration()
// ----------------------
// Set the angles for all servos simultaneously.
// Returns false if the requested angle is outside the range of the servo.
// Called from the main thread via Robot_Calculate().
extern bool Servos_SetAllAngles(float servo1Angle, float servo2Angle, float servo3Angle);

#endif /* SERVOS_H_ */
